//
//  SettingsViewController.swift
//  Chat Application 1.1
//
//  Created by Avaya on 03/10/2016.
//  Copyright © 2016 Avaya. All rights reserved.
//

import Foundation
import UIKit

class SettingsViewController: UIViewController,UITableViewDelegate,
                              UITableViewDataSource,UITextFieldDelegate,UINavigationControllerDelegate {
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell : UITableViewCell = tableView.dequeueReusableCell(withIdentifier: "groupCell", for: indexPath as IndexPath) as UITableViewCell
        
        cell.textLabel!.text = self.attrList[indexPath.row]
        
        return cell
    }

    var attrList = [String]()
    var ccURL: String?
    var ewtURL: String?
//    var coBrowseURL: String?
    var urlDictionary = [String: String]()
    
    @IBOutlet weak var tableView: UITableView!
    @IBOutlet weak var attrInput: UITextField!
    @IBOutlet weak var ccInput: UITextField!
    @IBOutlet weak var ewtInput: UITextField!
    @IBOutlet weak var coBrowseInput: UITextField!
    
    
    let stored = UserDefaults.standard
    
//
//    @IBAction func addAttribute_( sender: UIButton) {
//

//
//    }
    
    
    
    @IBAction func addRoutAttribute(_ sender: UIButton) {
        if attrInput.text != ""{

            attrList.append(attrInput.text!)

            attrInput.text = ""
            self.tableView.reloadData()
        }
    }
    
    
    
    @IBAction func deleteAttributes() {
        
        if attrList.count > 0 {
            attrList.removeLast()
            self.tableView.reloadData()
        }
    }

    
    override func viewDidLoad() {
        
        self.tableView.register(UITableViewCell.self, forCellReuseIdentifier: "groupCell")
        self.attrInput.delegate = self
        tableView.delegate = self
        tableView.dataSource = self
        navigationController?.delegate = self
        //setting stored values if they exist
        if stored.string(forKey: "customerURL") != nil {
            
            let temp: String = stored.string(forKey: "customerURL")!
            
            ccInput.text = temp
            ccURL = temp;
            urlDictionary["ccURL"] = temp;
        }
        else{
            ccInput.placeholder = "ws://10.00.000.00"
        }
        
        if stored.string(forKey: "ewtURL") != nil {
            
            let temp : String = stored.string(forKey: "ewtURL")!
            
            ewtInput.text = temp
            ewtURL = temp;
            urlDictionary["ewtURL"] = temp;
        }
        else{
            ewtInput.placeholder = "http://10.00.000.00"
        }
        
//        if stored.string(forKey: "coBrowseURL") != nil {
//
//            let temp : String = stored.string(forKey: "coBrowseURL")!
//
//            coBrowseInput.text = temp
//            coBrowseURL = temp;
//            urlDictionary["coBrowseURL"] = temp;
//        }
//        else{
//            coBrowseInput.placeholder = "10.00.000.00"
//        }
        
        if stored.array(forKey: "attributes")?.count ?? 0 > 0 {

            let attrStored : [String] = stored.array(forKey: "attributes") as! [String]
            attrList = attrStored
            self.tableView.reloadData()
        }
        else{
            attrInput.placeholder = "Service.Sales"
        }
    }
    

    
    
    @IBAction func addCcURL() {
        
        if ccInput.text != "" {
            ccURL = ccInput.text
            ccInput.textColor = UIColor.red
            ccInput.isUserInteractionEnabled = false
            urlDictionary["ccURL"] = ccURL;
            
        }
    }
    
    @IBAction func deleteCcURL() {
        
        ccInput.textColor = UIColor.black
        ccInput.isUserInteractionEnabled = true
        ccInput.text = ""
        ccURL = nil
        urlDictionary["ccURL"] = ccURL;
    }
    
    @IBAction func addEwt() {
        if !ewtInput.isEqual("")  {
            ewtURL = ewtInput.text
            ewtInput.textColor = UIColor.red
            ewtInput.isUserInteractionEnabled = false
            urlDictionary["ewtURL"] = ewtURL;
        }
    }
    
    @IBAction func deleteEwt() {
        
        ewtInput.textColor = UIColor.black
        ewtInput.isUserInteractionEnabled = true
        ewtInput.text = ""
        ewtURL = nil
        urlDictionary["ewtURL"] = ewtURL;
    }
    
    
//    @IBAction func addCobrowse() {
//        if coBrowseInput.text != "" {
//            coBrowseURL = coBrowseInput.text
//            coBrowseInput.textColor = UIColor.red
//            coBrowseInput.isUserInteractionEnabled = false
//            urlDictionary["coBrowseURL"] = coBrowseURL;
//        }
//    }
    
//    @IBAction func deleteCobrowse() {
//        coBrowseInput.textColor = UIColor.black
//        coBrowseInput.isUserInteractionEnabled = true
//        coBrowseInput.text = ""
//        coBrowseURL = nil
//        urlDictionary["coBrowseURL"] = coBrowseURL;
//
//    }
    
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return attrList.count
    }
    
    //fires when back button is pressed
    func navigationController(_ navigationController: UINavigationController, willShow viewController: UIViewController, animated: Bool) {
        
        stored.set(attrList, forKey: "attributes")
        stored.set(ccURL, forKey: "customerURL")
        stored.set(ewtURL, forKey: "ewtURL")
//        stored.set(coBrowseURL, forKey: "coBrowseURL")
        
        
        
        if let controller = viewController as? ViewController {
            
            controller.addressDictionary = urlDictionary
            controller.attributesList = attrList

        }
    }
    
    
}
